/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.invoke.arg.ArgsClassGenerator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IClassGenerator;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.ISyntheticClassInfo;
import org.spongepowered.asm.util.IConsumer;

public class MixinInternals {
    private static final Field TARGET_CLASS_CONTEXT_MIXINS_FIELD;
    private static final Method MIXIN_INFO_GET_STATE_METHOD;
    private static final Field STATE_CLASS_NODE_FIELD;
    private static final Field EXTENSIONS_FIELD;
    private static final Field ACTIVE_EXTENSIONS_FIELD;
    private static final Field INJECTION_INFO_TARGET_NODES_FIELD;
    private static final Field ARGS_CLASS_GENERATOR_REGISTRY_FIELD;
    private static final Field INJECTION_NODE_DECORATIONS_FIELD;
    private static final Field INJECTION_INFO_INJECTOR_FIELD;

    public static List<Pair<IMixinInfo, ClassNode>> getMixinsFor(ITargetClassContext context) {
        try {
            ArrayList<Pair<IMixinInfo, ClassNode>> result = new ArrayList<Pair<IMixinInfo, ClassNode>>();
            SortedSet mixins = (SortedSet)TARGET_CLASS_CONTEXT_MIXINS_FIELD.get(context);
            for (IMixinInfo mixin : mixins) {
                result.add((Pair<IMixinInfo, ClassNode>)Pair.of((Object)mixin, (Object)MixinInternals.getClassNode(mixin)));
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    public static Map<Target, List<InjectionNodes.InjectionNode>> getTargets(InjectionInfo info) {
        try {
            return (Map)INJECTION_INFO_TARGET_NODES_FIELD.get(info);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    public static void registerExtension(IExtension extension) {
        try {
            IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
            Extensions extensions = (Extensions)transformer.getExtensions();
            List extensionsList = (List)EXTENSIONS_FIELD.get(extensions);
            MixinInternals.addExtension(extensionsList, extension);
            ArrayList<IExtension> activeExtensions = new ArrayList<IExtension>((List)ACTIVE_EXTENSIONS_FIELD.get(extensions));
            MixinInternals.addExtension(activeExtensions, extension);
            ACTIVE_EXTENSIONS_FIELD.set(extensions, Collections.unmodifiableList(activeExtensions));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    private static void addExtension(List<IExtension> extensions, IExtension newExtension) {
        String extensionClassName = newExtension.getClass().getName();
        extensionClassName = extensionClassName.substring(extensionClassName.lastIndexOf(46));
        int index = -1;
        for (int i = 0; i < extensions.size(); ++i) {
            IExtension extension = extensions.get(i);
            if (!extension.getClass().getName().endsWith(extensionClassName)) continue;
            index = i;
        }
        if (index == -1) {
            extensions.add(newExtension);
        } else {
            extensions.add(index + 1, newExtension);
        }
    }

    public static void registerClassGenerator(Function<IConsumer<ISyntheticClassInfo>, IClassGenerator> classGenerator) {
        try {
            IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
            Extensions extensions = (Extensions)transformer.getExtensions();
            ArgsClassGenerator argsClassGenerator = (ArgsClassGenerator)extensions.getGenerator(ArgsClassGenerator.class);
            IConsumer registry = (IConsumer)ARGS_CLASS_GENERATOR_REGISTRY_FIELD.get(argsClassGenerator);
            extensions.add(classGenerator.apply((IConsumer<ISyntheticClassInfo>)registry));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    public static Map<String, Object> getDecorations(InjectionNodes.InjectionNode node) {
        try {
            return (Map)INJECTION_NODE_DECORATIONS_FIELD.get(node);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    public static Injector getInjector(InjectionInfo info) {
        try {
            return (Injector)INJECTION_INFO_INJECTOR_FIELD.get(info);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    private static ClassNode getClassNode(IMixinInfo mixin) {
        try {
            Object state = MIXIN_INFO_GET_STATE_METHOD.invoke((Object)mixin, new Object[0]);
            return (ClassNode)STATE_CLASS_NODE_FIELD.get(state);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to use mixin internals, please report to LlamaLad7!", e);
        }
    }

    static {
        try {
            Class<?> TargetClassContext2 = Class.forName("org.spongepowered.asm.mixin.transformer.TargetClassContext");
            TARGET_CLASS_CONTEXT_MIXINS_FIELD = TargetClassContext2.getDeclaredField("mixins");
            TARGET_CLASS_CONTEXT_MIXINS_FIELD.setAccessible(true);
            Class<?> MixinInfo = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo");
            MIXIN_INFO_GET_STATE_METHOD = MixinInfo.getDeclaredMethod("getState", new Class[0]);
            MIXIN_INFO_GET_STATE_METHOD.setAccessible(true);
            Class<?> State = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo$State");
            STATE_CLASS_NODE_FIELD = State.getDeclaredField("classNode");
            STATE_CLASS_NODE_FIELD.setAccessible(true);
            INJECTION_INFO_TARGET_NODES_FIELD = InjectionInfo.class.getDeclaredField("targetNodes");
            INJECTION_INFO_TARGET_NODES_FIELD.setAccessible(true);
            EXTENSIONS_FIELD = Extensions.class.getDeclaredField("extensions");
            EXTENSIONS_FIELD.setAccessible(true);
            ACTIVE_EXTENSIONS_FIELD = Extensions.class.getDeclaredField("activeExtensions");
            ACTIVE_EXTENSIONS_FIELD.setAccessible(true);
            ARGS_CLASS_GENERATOR_REGISTRY_FIELD = ArgsClassGenerator.class.getDeclaredField("registry");
            ARGS_CLASS_GENERATOR_REGISTRY_FIELD.setAccessible(true);
            INJECTION_NODE_DECORATIONS_FIELD = InjectionNodes.InjectionNode.class.getDeclaredField("decorations");
            INJECTION_NODE_DECORATIONS_FIELD.setAccessible(true);
            INJECTION_INFO_INJECTOR_FIELD = InjectionInfo.class.getDeclaredField("injector");
            INJECTION_INFO_INJECTOR_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to access some mixin internals, please report to LlamaLad7!", e);
        }
    }
}

